
#version 150 compatibility 

uniform mat4 mat_view ;
uniform mat4 mat_proj ;
uniform mat4 mat_world ;

/// mix pos1 - pos2
uniform float uni_interpolator ;

/// determins the position of the logo
/// these positions are relative to mat_world, the view space trafo.
vec2 pos1 = vec2(0.0,2.0) ;
vec2 pos2 = vec2(0.0,5.0) ;

void main()
{
	// ohh, we know how the quad is build ;)
	gl_TexCoord[0].xy = sign(gl_Vertex.xy) * 0.5 + 0.5 ;

	vec4 vertex = gl_Vertex ;
	
	//
	// component *= base * scale 
	vertex.x *= 2.08 * 3.0 ;
	vertex.y *= 1.91 * 3.0 ;
	vertex.w = 1.0 ;
	
	// first go to view space.
	vertex = mat_view * vertex ;
	// transform in view space
	vertex.xy += mix( pos1, pos2, smoothstep(0.0,1.0,uni_interpolator) ) ;
	
	// mat_world is a view space trafo. It is the base transformation for the logo.
	gl_Position = mat_proj * mat_world * vertex ;
}